#include "MTNumberEditor.h"
#include "MTSimpleResource.h"
#include "MTExceptions.h"

MTNumberEditor::MTNumberEditor()
{
	variant = 0;
	value = 0;
}

MTNumberEditor::~MTNumberEditor()
{
	
}

void MTNumberEditor::ReadEditorData(void)
{
	if(variant & kTypeSpecialType)
	{
		switch((variant >> kTypeDataArea1Shift) & kTypeDataArea1ShiftMask)
		{
			case kCustomTypeFloat:
				value = ResourceReadData((UInt8 *)basePtr, 4, 1, 1);
				break;
			
			default:
				throw MTUnsupportedException("MTNumberEditor was assigned a bad special type");
				break;
		}
	}
	else
	{
		value = ResourceReadData((UInt8 *)basePtr, variant);
	}
}

void MTNumberEditor::WriteEditorData(void)
{
	UInt32	theValue;
	Str255	theString;
	
	ReadTextBox(theString);
	
	if(ReadText(theString, &theValue))
	{
		if(variant & kTypeSpecialType)
		{
			switch((variant >> kTypeDataArea1Shift) & kTypeDataArea1ShiftMask)
			{
				case kCustomTypeFloat:
					ResourceWriteData((UInt8 *)basePtr, 4, 1, 1, theValue);
					break;
				
				default:
					throw MTUnsupportedException("MTNumberEditor was assigned a bad special type");
					break;
			}
		}
		else
		{
			ResourceWriteData((UInt8 *)basePtr, variant, theValue);
		}
	}
	else
	{
		SysBeep(1);
	}
}

void MTNumberEditor::GetOriginalText(StringPtr text)
{
	char	buf[256];
	
	ResourcePrintDataSimple(buf, value, variant);
	CopyCStringToPascal(buf, text);
}

UInt8 MTNumberEditor::ReadText(StringPtr text, UInt32 * outValue)
{
	char	buf[256];
	UInt32	theValue;
	UInt8	numRead = 0;
	
	CopyPascalStringToC(text, buf);
	
	if(variant & kTypeSpecialType)
	{
		switch((variant >> kTypeDataArea1Shift) & kTypeDataArea1ShiftMask)
		{
			case kCustomTypeFloat:
				numRead = std::sscanf(buf, "%f", &theValue);
				break;
			
			default:
				throw MTUnsupportedException("MTNumberEditor was assigned a bad special type");
				break;
		}
	}
	else
	{
		if(variant & kTypeDisplayAsDec)
		{
			if(variant & kTypeIsUnsigned)
			{
				numRead = std::sscanf(buf, "%lu", &theValue);
			}
			else
			{
				numRead = std::sscanf(buf, "%ld", &theValue);
			}
		}
		else
		{
			numRead = std::sscanf(buf, "%p", &theValue);
		}
	}
	
	*outValue = theValue;
	
	return (numRead == 1);
}
